#include <bits/stdc++.h>
#include <math.h>
#include <algorithm>
using namespace std;
#define ll long long
#define ld long double
#define pb push_back
#define mp make_pair
#define ins insert
#define vi vector<int>
const int mxN = 1e9;
const ll mod = 1e9 + 7;

void add_edge(vector<pair<int, char>> adj[], int U, int V, char c)
{
    adj[U].pb(mp(V, c));
    adj[V].pb(mp(U, c));
}
bool BFS(vector<pair<int, char>> adj[], int U, int V, int n,
         int prev[], int dist[])
{
    list<int> queue;
    bool visited[n];
    for (int i = 0; i < n; i++)
    {
        visited[i] = false;
        dist[i] = INT_MAX;
        prev[i] = -1;
    }
    visited[U] = true;
    dist[U] = 0;
    queue.pb(U);
    while (!queue.empty())
    {
        int u = queue.front();
        queue.pop_front();
        for (int i = 0; i < adj[u].size(); i++)
        {
            if (visited[adj[u][i].first] == false)
            {
                visited[adj[u][i].first] = true;
                dist[adj[u][i].first] = dist[u] + 1;
                prev[adj[u][i].first] = u;
                queue.pb(adj[u][i].first);
                if (adj[u][i].first == V)
                    return true;
            }
        }
    }

    return false;
}
int Distance(vector<pair<int, char>> adj[], int U,
             int V, int n)
{
    int prev[n], dist[n];
    if (BFS(adj, U, V, n, prev, dist) == false)
        return 0;
    vector<int> path;
    int curr = V;
    path.pb(curr);
    while (prev[curr] != -1)
    {
        path.pb(prev[curr]);
        curr = prev[curr];
    }
    if (dist[V] % 3 != 0)
        return 0;
    vector<int> c(3, 0);
    for (int i = path.size() - 1; i >= 1; i--)
    {
        //cout << path[i] + 1 << " ";
        for (auto it = adj[path[i]].begin(); it != adj[path[i]].end(); it++)
        {
            int ind = it->first;
            char ch = it->second;
            if (ind == path[i - 1])
            {
                //cout << ind + 1 << " ";
                if (ch == 'S')
                    c[0]++;
                else if (ch == 'I')
                    c[1]++;
                else
                    c[2]++;
                break;
            }
        }
    }
    /* cout << "\n";
    for (int i = path.size() - 1; i >= 0; i--)
        cout << path[i] + 1 << " ";
    cout << "\n";
    cout << c[0] << " " << c[1] << " " << c[2] << "\n"; */
    if (c[0] == c[1] && c[1] == c[2])
        return 1;
    else
        return 0;
}
//last_fix
int main()
{
    int n;
    cin >> n;
    vector<pair<int, char>> adj[n];
    bool ok = 1;
    vector<pair<int, char>> cont;
    for (int i = 1; i < n; i++)
    {
        int x, y;
        char c;
        cin >> x >> y >> c;
        x--, y--;
        cont.pb(mp(min(x, y), c));
        if (abs(x - y) != 1)
            ok = 0;
        add_edge(adj, x, y, c);
    }
    int ans = 0;
    if (ok)
    {
        vector<int> c0(n - 1, 0), c1(n - 1, 0), c2(n - 1, 0);
        sort(cont.begin(), cont.end());
        if (cont[0].second == 'S')
            c0[0]++;
        else if (cont[0].second == 'I')
            c1[0]++;
        else
            c2[0]++;
        for (int i = 1; i < n - 1; i++)
        {
            c0[i] = c0[i - 1];
            c1[i] = c1[i - 1];
            c2[i] = c2[i - 1];
            if (cont[i].second == 'S')
                c0[i]++;
            else if (cont[i].second == 'I')
                c1[i]++;
            else
                c2[i]++;
            if (c0[i] == c1[i] && c1[i] == c2[i])
                ans++;
        }
        for (int i = 1; i < n - 1; i++)
        {
            for (int j = i + 2; j < n - 1; j++)
            {
                int t0 = c0[j] - c0[i - 1];
                int t1 = c1[j] - c1[i - 1];
                int t2 = c2[j] - c2[i - 1];
                if (t0 == t1 && t1 == t2)
                    ans++;
            }
        }
        cout << ans;
    }
    else
    {
        for (int i = 0; i < n; i++)
        {
            for (int j = i + 1; j < n; j++)
            {
                ans += Distance(adj, i, j, n);
            }
        }
        cout << ans;
    }
    return 0;
}